//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Verify IP CMP Response and install certificates
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
//#define CMP_SECRET  "qwerty09"
#define CMP_SECRET  "qwerty39"
//#define CMP_SECRET  "qwerty02"
#define CMP_IP_FILE "cmp_ip.bin"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
//------------------------------------------------------------------------------
//    CMP-   CMP/IR
// :
// 1.   
// 2.    CMP-   CMP/IP,   
//       () 
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey,hImpKey;
 DWORD len,dw,type,sz,status;
 char transID[65],tim[32];

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   
 if (getFileLen(CMP_IP_FILE,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_IP_FILE,WBuf,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //   
 if (!CPImportKey(hProv,WBuf,sz,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 len=sizeof(type);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TYPE,(BYTE*)&type,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TYPE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //      
 if (type==PKI_CMP_ERROR) {
   len=sizeof(dw);
   if (!CPGetKeyParam(hProv,hKey,KP_CMP_STATUS,(BYTE*)&dw,&len,0)) {
     printf("CPGetKeyParam KP_CMP_STATUS Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   printf("PKI_CMP_ERROR, STATUS: %d (%s)\n",dw,code2status(dw));
   dw=0xFF;
   len=sizeof(dw);
   if (!CPGetKeyParam(hProv,hKey,KP_CMP_FAIL,(BYTE*)&dw,&len,0)) {
     printf("CPGetKeyParam KP_CMP_FAIL Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   if (dw!=0xFF) printf("FAIL: %d (%s)\n",dw,code2fail(dw));
   return 1;
 }
 //     
 if (type!=PKI_CMP_IP) {
   printf("Unknown CMP TYPE: %d\n",type);
   return 1;
 }
 //  transactionID
 len=sizeof(transID);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TRANS_ID,(BYTE*)transID,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TRANS_ID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 transID[len]=0;
 printf("transactionID = %s\n",transID);
 //     
 if (!CPGenKey(hProv,CALG_CMP_KEY,CRYPT_EXPORTABLE,&hImpKey)) {
   printf("CPGenKey CALG_CMP_KEY Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPSetKeyParam(hProv,hImpKey,KP_CMP_SECRET,(BYTE*)CMP_SECRET,0)) {
   printf("CPSetKeyParam KP_CMP_SND_KID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //       
 if (!CPVerifySignature(hProv,0,WBuf,sz,hImpKey,NULL,CRYPT_OBJECT_CMP)) {
   printf("CPVerifySignature Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 len=sizeof(status);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_STATUS,(BYTE*)&status,&len,0)) {
   printf("CPGetKeyParam KP_CMP_STATUS Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (status == PKISTATUS_INFO_WAITING) {
   len=sizeof(tim); tim[0]=0;
   CPGetKeyParam(hProv,hKey,KP_CMP_SERVER_WAIT,(BYTE*)tim,&len,0);
   if (tim[0]) printf("SERVER_WAIT: %s",tim);
 }
 else if (status == PKISTATUS_INFO_ACCEPTED || status == PKISTATUS_INFO_GRANTED_WITH_MODS) {
   CPDestroyKey(hProv,hKey);
   //    
   if (!CPGetUserKey(hProv,AT_SIGNATURE,&hKey)) {
     printf("CPGetUserKey AT_SIGNATURE Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   //  
   if (!CPSetKeyParam(hProv,hKey,KP_CERTIFICATE,WBuf,0)) {
     printf("CPSetKeyParam KP_CERTIFICATE Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   //   
   if (!CPSetKeyParam(hProv,hKey,KP_CERTIFICATE_CA,WBuf,0)) {
     printf("CPSetKeyParam KP_CERTIFICATE_CA Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
 }
 else {
   printf("PKISTATUS Error, status=%d\n",status);
   return 1;
 }
 CPDestroyKey(hProv,hKey);
 CPDestroyKey(hProv,hImpKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
